-- BLINK example
-- based on http://thebcfactor.net/electronics/programmable-logic/lattice-icestick/example-1/
-- modified to be similar to 2 LED IceStudio example

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity BLINK is
port(
  led1 : out std_logic;
  led2 : out std_logic;
  clk : in std_logic
);
end BLINK;

architecture Behavior of BLINK is
  signal count : std_logic_vector(23 downto 0);

begin
  process(clk)
    begin
      if (rising_edge(clk)) then
         if (count < 4194304) then
           count <= count+1;
           led2 <= not led1;
          else
           led1 <= not led1;
           count <= 0;
          end if;
        end if;
    end process;
end Behavior;